/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asn1invnentorydefinition;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDevRet
implements FStruct {
    public int iDevID = -1;
    public BigInteger iRet;
    public byte[] strErrInfo = null;

    public AsnDevRet() {
    }

    public AsnDevRet(AsnDevRet arg) {
        this.iDevID = arg.iDevID;
        this.iRet = arg.iRet;
        if (arg.strErrInfo != null) {
            this.strErrInfo = new byte[arg.strErrInfo.length];
            System.arraycopy(arg.strErrInfo, 0, this.strErrInfo, 0, arg.strErrInfo.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.iDevID));
        enc.serializeInteger(this.iRet);
        if (this.strErrInfo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strErrInfo);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iDevID = bi.intValue();
        }
        this.iRet = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strErrInfo = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevID = ");
        os.print(this.iDevID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iRet = ");
        os.print(this.iRet.toString());
        os.println(',');
        if (this.strErrInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strErrInfo = ");
            os.print(FStruFormat.convertToString((byte[])this.strErrInfo));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

