/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.asn1invnentorydefinition;

import com.huawei.network.qasn.asnutil.AsnIntList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnBoardSubCards
implements FStruct {
    public BigInteger slotID;
    public AsnIntList subCardIDList = new AsnIntList();

    public AsnBoardSubCards() {
    }

    public AsnBoardSubCards(AsnBoardSubCards arg) {
        this.slotID = arg.slotID;
        this.subCardIDList = new AsnIntList(arg.subCardIDList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.slotID);
        this.subCardIDList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.slotID = dec.deserializeInteger();
        this.subCardIDList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("slotID = ");
        os.print(this.slotID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subCardIDList = ");
        this.subCardIDList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

