/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;

public final class FrameworkStarter {
    private static final String OSGI_ENTRY = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String IMAP_ROOT_EVN = "IMAP_ROOT";
    private static final String UFLIGHT_PATH = "common/uflight";
    private static final String DEPLOYMENT_MODE = "deploymentMode";
    private static final String INSTANCE_DIR = "INSTANCE_DIR";
    private static final String INSTANCE_NAME = "instanceName";
    private static final String CONFIGUREATION = "-configuration";

    private FrameworkStarter() {
    }

    public static void main(String[] args) throws Exception {
        final String[] args_constans = args;
        new Thread(){

            @Override
            public void run() {
                try {
                    CountDownLatch doneSignal = new CountDownLatch(10);
                    String deployModeProp = System.getProperty(FrameworkStarter.DEPLOYMENT_MODE);
                    boolean isIntegratedDeployment = null == deployModeProp ? false : DeploymentMode.integrated.toString().equalsIgnoreCase(deployModeProp.trim());
                    FrameworkStarter.ensureInstanceName();
                    String[] args_inner = args_constans;
                    if (isIntegratedDeployment) {
                        System.getProperties().put("user.dir", System.getenv(FrameworkStarter.IMAP_ROOT_EVN) + File.separator + FrameworkStarter.UFLIGHT_PATH);
                        args_inner = FrameworkStarter.replaceConfigureation(args_inner);
                        FrameworkStarter.readConfig();
                    }
                    Class<?> cls = Class.forName(FrameworkStarter.OSGI_ENTRY);
                    Method main = cls.getMethod("main", String[].class);
                    Object[] params = new Object[]{args_inner};
                    main.invoke(null, params);
                    doneSignal.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    private static String[] replaceConfigureation(String[] args) {
        ArrayList<String> arrList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(CONFIGUREATION)) {
                arrList.add(args[i]);
                continue;
            }
            arrList.add(args[i]);
            String instancePath = "conf" + File.separator + System.getProperty(INSTANCE_NAME);
            arrList.add(instancePath);
            ++i;
        }
        return arrList.toArray(new String[arrList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfig() throws IOException {
        InputStream configInput = null;
        try {
            configInput = new FileInputStream(System.getProperty("user.dir") + "/conf/config.ini");
            System.getProperties().load(configInput);
        }
        finally {
            configInput.close();
        }
    }

    private static void ensureInstanceName() {
        String instanceName = System.getProperty(INSTANCE_NAME);
        if (null == instanceName) {
            String instanceDir = System.getenv(INSTANCE_DIR);
            if (null == instanceDir) {
                throw new IllegalArgumentException("instanceName and instanceDir not configed");
            }
            File dir = new File(instanceDir);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IllegalArgumentException("instanceDir is not exist");
            }
            instanceName = dir.getName().trim();
            System.setProperty(INSTANCE_NAME, instanceName);
        }
    }

    private static enum DeploymentMode {
        integrated,
        independent;

    }
}

